<?php
include 'session.php';


// =====Pagination====

if (isset($_GET['page'])) {
    $page = $_GET['page'];
    if ($page <= 0) {
        $page = 1;
    }
} else {
    $page = 1;
}
$per_page = 30;
$start = ($page - 1) * $per_page;

$totalReports = mysqli_num_rows(mysqli_query($conn, "SELECT `id` FROM `reports`"));
$totalPage = ceil($totalReports / $per_page);

$quser = "SELECT id, report, reported_id,reported_by, type, date FROM reports ORDER BY id DESC";
$users = mysqli_query($conn, $quser);


?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Report</title>
    <link rel="stylesheet" href="css/table.css">
</head>

<style>
    td a {
        color: #0047d6;
    }

    td a i {
        font-size: 25px;

    }
</style>

<body>
    <?php include_once('includes/header.php'); ?>




    <!-- =======================User LIST================ -->


    <table>

        <tr>
            <th>ID</th>
            <th>Report</th>
            <th>Reported By</th>
            <th>Type</th>
            <th>ON</th>
            <th>Date</th>
            <!-- <th>Details</th> -->
        </tr>

        <?php

        while ($r = mysqli_fetch_assoc($users)) {


            // r.id , r.report,u.profile,u.name,r.type,r.date 
            $id = $r['id'];
            $report = $r['report'];
            $report_id = $r['reported_id'];
            $by= $r['reported_by'];
            $type = $r['type'];
            $date = $r['date'];

        ?>
            <tr>
                <td><?php echo $id ?></td>
                <td><?php echo $report ?></td>
                <td><?php echo $by ?></td>
                <td><?php echo $type ?></td>
                <td><?php echo $type . " id = " . $report_id ?></td>
                <td><?php echo $date ?></td>
                <!-- <td><a href="crud/details_report.php?id=<?php echo $id ?>&type=<?php echo $type ?>"><i class="fa-solid fa-users-viewfinder"></i></a></td> -->

            </tr>

        <?php
        }

        ?>



    </table>

    <!-- ===============Pagination=============== -->

    <div class="pagination">
        <a href="<?php
                    if ($page > 1) {
                        echo "?page=" . ($page - 1);
                    }
                    ?>">Pre</a>
        <?php
        for ($i = 1; $i <= $totalPage; $i++) {
            if ($i == $page) {
                echo "<a href='?page=" . $i . "' class='active'>" . $i . "</a>";
            } else {
                echo "<a href='?page=" . $i . "'>" . $i . "</a>";
            }
        ?>
        <?php
        }
        ?>
        <a href="<?php

                    if ($page < $totalPage) {
                        echo "?page=" . ($page + 1);
                    }
                    ?>">Next</a>
    </div>






    <?php include_once('includes/footer.php'); ?>