<?php

include 'session.php';

if (isset($_GET['page'])) {
    $page = $_GET['page'];
    if ($page <= 0) {
        $page = 1;
    }
} else {
    $page = 1;
}
$per_page = 30;
$start = ($page - 1) * $per_page;

$video;
if (isset($_GET['q'])) {
    $search = $_GET['q'];

    $qvideo = "SELECT `id`, `video`,`cover`, `title`,`views`,`status` FROM `video` 
    WHERE lower(title) LIKE lower('%$search%') && status ='0' ORDER BY id DESC limit 100";

    $video = mysqli_query($conn, $qvideo);
} else {
    $search = "Search Here...";
    $video = mysqli_query($conn, "SELECT `id`,`video`, `cover`, `title`,`views`,`status` FROM `video` WHERE status ='0' ORDER BY id DESC limit $start,$per_page");
}


// =====Pagination====

$totalUsers = mysqli_num_rows(mysqli_query($conn, "SELECT `id` FROM `video` WHERE status = '0' "));
$totalPage = ceil($totalUsers / $per_page);

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pending Video</title>
    <link rel="stylesheet" href="css/table.css">
</head>
<style>
    input[type=search] {
        height: 40px;
        width: 70%;
        background-color: #e3e3e3;
        border-radius: 10px;
        margin: 10px auto;
        padding: 0px 10px;
        display: block;
        border: none;
        outline: none;
    }

    input[type=search]:focus {
        outline: 1px solid #e5e5e5;
    }

    #thumbnail {
        height: 100px;
        width: 80px;
        position: cover;
        border-radius: 10px;
    }


    #actions {
        width: auto;
        display: flex;
        justify-content: space-around;
        align-items: center;
        text-align: center;
        height: 120px;
    }

    #actions i,
    #action input {
        color: #004fe3;
        margin-left: 20px;
    }

    #actions i,
    #action input {
        font-size: 20px;
    }
</style>

<body>
    <?php include_once('includes/header.php'); ?>



    <!-- =======================User LIST================ -->

    <form action="" method="get" id="search_f">
        <input type="search" name="q" id="search" placeholder="<?php echo $search ?>">
    </form>


    <table>

        <tr>
            <th>ID</th>
            <th>Cover</th>
            <th>Title</th>
            <th>Views</th>
            <th>Action</th>
        </tr>

        <?php

        while ($r = mysqli_fetch_assoc($video)) {

            $id = $r['id'];
            $vid = $r['video'];
            $cover = $r['cover'];
            $title = $r['title'];
            $views = $r['views'];
            $status = $r['status'];
        ?>
            <tr>
                <td><?php echo $id ?></td>

                <td onclick="openVideo('<?php echo $id ?>')"><img src="<?php echo "../videos/thumbnail/" . $cover ?>" id="thumbnail"></td>

                <td><?php echo $title ?></td>
                <td><?php echo $views ?></td>
                <?php
                if ($status == "1") {
                ?>
                    <td id="actions">
                        <input type="checkbox" checked onclick="publishVideo('<?php echo $id ?>',this)" id="status">
                        <i class="fa fa-trash" onclick="deleteVideo('<?php echo $id ?>','<?php echo $vid ?>','<?php echo $cover ?>')"></i>
                    </td>
                <?php
                } else {
                ?>
                    <td id="actions">
                        <input type="checkbox" onclick="publishVideo('<?php echo $id ?>',this)" id="status">
                        <i class="fa fa-trash" onclick="deleteVideo('<?php echo $id ?>','<?php echo $vid ?>','<?php echo $cover ?>')"></i>
                    </td>
                <?php
                }
                ?>

            </tr>

        <?php
        }

        ?>



    </table>

    <!-- ===============Pagination=============== -->

    <div class="pagination">
        <a href="<?php
                    if ($page > 1) {
                        echo "?page=" . ($page - 1);
                    }
                    ?>">Pre</a>
        <?php
        for ($i = 1; $i <= $totalPage; $i++) {
            if ($i == $page) {
                echo "<a href='?page=" . $i . "' class='active'>" . $i . "</a>";
            } else {
                echo "<a href='?page=" . $i . "'>" . $i . "</a>";
            }
        ?>
        <?php
        }
        ?>
        <a href="<?php

                    if ($page < $totalPage) {
                        echo "?page=" . ($page + 1);
                    }
                    ?>">Next</a>
    </div>


    <!-- ================EXTRA JS===================== -->


    <script>
        function deleteVideo(id, vid, cover) {

            if (window.confirm("Are you sure want to delete it")) {
                console.log("deleteing");
                var xhttp = new XMLHttpRequest();
                xhttp.onreadystatechange = function() {
                    if (this.readyState == 4 && this.status == 200) {

                        let res = xhttp.responseText;
                        console.log(res);
                        if (res == "1") {
                            location.reload();
                        } else {
                            alert("Failed To delete");
                        }
                    }
                };
                let url = "crud/delete_video.php?id=" + id + "&vid=" + vid + "&cover=" + cover;
                xhttp.open("GET", url, true);
                xhttp.send();
            }

        }

        function publishVideo(id, check) {

            if (window.confirm("Are you sure want to publish it")) {
                if (check.checked) {
                    setPublish(id, "1");
                } else {
                    setPublish(id, "0");
                }
            } else {
                check.checked = false;
            }


        }

        function setPublish(id, status) {

            var xhttp = new XMLHttpRequest();
            xhttp.onreadystatechange = function() {
                if (this.readyState == 4 && this.status == 200) {
                    console.log(xhttp.responseText);
                }
            };

            let url = "crud/crud_unpublish.php?id=" + id + "&status=" + status;
            xhttp.open("GET", url, true);
            xhttp.send();
        }

        function openVideo(vid) {
            window.open("video_player.php?id=" + vid);
        }
    </script>


    <?php include_once('includes/footer.php'); ?>