<?php
include 'session.php';

if (isset($_GET['page'])) {
    $page = $_GET['page'];
    if ($page <= 0) {
        $page = 1;
    }
} else {
    $page = 1;
}
$per_page = 30;
$start = ($page - 1) * $per_page;


$feedback = mysqli_query($conn, "SELECT `id`, `em`, `topic`,`message` FROM `contact` ORDER BY id DESC limit $start,$per_page");


// =====Pagination====

$totalFeebacks = mysqli_num_rows(mysqli_query($conn, "SELECT `id` FROM `contact`"));
$totalPage = ceil($totalFeebacks / $per_page);



?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Feeback</title>
    <link rel="stylesheet" href="css/table.css">
</head>

<style>


</style>

<body>
    <?php include_once('includes/header.php'); ?>




    <table>

        <tr>
            <th>ID</th>
            <th>Topic</th>
            <th>Message</th>
            <th>Contact</th>
        </tr>

        <?php

        while ($r = mysqli_fetch_assoc($feedback)) {

            $id = $r['id'];
            $contact = $r['em'];
            $topic = $r['topic'];
            $msg = $r['message'];
        ?>
            <tr>
                <td><?php echo $id ?></td>
                <td><?php echo $topic ?></td>
                <td><?php echo $msg ?></td>
                <td><?php echo $contact ?></td>
            
            </tr>

        <?php
        }

        ?>



    </table>

    <!-- ===============Pagination=============== -->

    <div class="pagination">
        <a href="<?php
                    if ($page > 1) {
                        echo "?page=" . ($page - 1);
                    }
                    ?>">Pre</a>
        <?php
        for ($i = 1; $i <= $totalPage; $i++) {
            if ($i == $page) {
                echo "<a href='?page=" . $i . "' class='active'>" . $i . "</a>";
            } else {
                echo "<a href='?page=" . $i . "'>" . $i . "</a>";
            }
        ?>
        <?php
        }
        ?>
        <a href="<?php

                    if ($page < $totalPage) {
                        echo "?page=" . ($page + 1);
                    }
                    ?>">Next</a>
    </div>




    <?php include_once('includes/footer.php'); ?>