<?php
include 'session.php';
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard</title>
</head>

<style>
    .dashboard {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
        height: 100vh;
        grid-gap: 20px;
    }

    .dashboard a {
        background-color: var(--color-primary);
        color: #FFFFFF;
        display: flex;
        height: 140px;
        border-radius: 20px;
        justify-content: center;
        flex-direction: column;
        align-items: center;
        cursor: pointer;
    }

    .dashboard a i {
        font-size: 25px;
    }

    .dashboard a span {
        margin-top: 20px;
        font-size: 18px;
    }
</style>

<body>
    <?php include_once('includes/header.php'); ?>


    <?php

    $user = "SELECT `id` FROM users";
    $totalUsers = mysqli_num_rows(mysqli_query($conn, $user));

    $video = "SELECT `id` FROM video";
    $totalvideos = mysqli_num_rows(mysqli_query($conn, $video));

    ?>

    <div class="dashboard">
        <a href="users.php">
            <i class="fas fa-users"></i>
            <span><?php echo $totalUsers ?> USERS</span>
        </a>

        <a href="videos.php">
            <i class="fas fa-video"></i>
            <span><?php echo $totalvideos ?> Videos</span>
        </a>

        <a href="notification.php?to=chikuai">
            <i class="fas fa-bell"></i>
            <span>Send Notification</span>
        </a>

        <a href="settings.php">
            <i class="fas fa-gears"></i>
            <span>Settings</span>
        </a>


    </div>



    <?php include_once('includes/footer.php'); ?>