<?php

require_once('app.php');

$slider = mysqli_query($conn, "SELECT * FROM `sliders` ORDER BY pos DESC");

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Slider</title>
    <link rel="stylesheet" href="css/table.css">
    <link rel='icon' href='img/fav.png'>
</head>

<style>
    .cover {
        width: 140px !important;
        height: auto !important;
        min-height: 60px;
        object-fit: cover;
        border-radius: 5px;
    }

    .cover.mobile {
        width: 140px !important;
        height: auto !important;
        min-height: 60px;
        object-fit: cover;
        border-radius: 5px;
    }

    .cover.desktop {
        width: 180px !important;
        height: auto !important;
        min-height: 40px;
        border-radius: 5px;
    }

    tr td {
        max-width: fit-content;
    }
</style>

<body>
    <?php include_once('includes/header.php'); ?>

    <table class="caption-top">

        <div class="table_header">
            <a href="sliders_add">Add More</a>
        </div>


        <caption>Sliders</caption>

        <tr>
            <th>ID</th>
            <th>Cover</th>
            <th>Title</th>
            <th>Type</th>
            <th>Value</th>
            <th>Position</th>
            <th>Actions</th>
        </tr>

        <?php

        while ($r = mysqli_fetch_assoc($slider)) {

            $id = $r['id'];
            $title = $r['title'];
            $cover = $r['cover'];
            $type = $r['type'];
            $value = $r['value'];
            $pos = $r['pos'];
            $status = $r['status'];

        ?>
            <tr>
                <td><?php echo $id ?></td>
                <td><img src="<?php echo getImages($cover) ?>" class="cover" loading="lazy"></td>
                <td class="fill"><?php echo $title ?></td>
                <td><?php echo $type ?></td>
                <td><?php echo $value ?></td>
                <td><?php echo $pos ?></td>

                <td class="actions">
                    <input type="checkbox" <?php echo $status == "1" ? "checked" : ""; ?> onclick="changeStatus('<?php echo $id ?>',this)" title="Visibility">
                    <a href="sliders_add?id=<?php echo $id ?>" class="dodgerblue"><i class="bx bx-edit"></i></a>
                    <a onclick="deleteSlider('<?php echo $id ?>')" class="red"><i class="bx bx-trash"></i></a>
                </td>
            </tr>

        <?php
        }

        ?>

    </table>


    <script>
        function changeStatus(id, check) {
            if (check.checked) {
                setStatus(id, "1");
            } else {
                setStatus(id, "0");
            }
        }

        function setStatus(id, status) {
            var xhttp = new XMLHttpRequest();
            xhttp.onreadystatechange = function() {
                if (this.readyState == 4 && this.status == 200) {
                    console.log(xhttp.responseText);
                }
            };

            let url = "function?type=sliders_update&id=" + id + "&status=" + status;
            xhttp.open("GET", url, true);
            xhttp.send();
        }


        function deleteSlider(id) {
            if (window.confirm("Are you sure want to delete it")) {
                var xhttp = new XMLHttpRequest();
                xhttp.onreadystatechange = function() {
                    if (this.readyState == 4 && this.status == 200) {

                        let res = xhttp.responseText;
                        if (res.includes("1")) {
                            location.reload();
                        } else {
                            alert("Failed To delete");

                        }
                    }
                };
                let url = "function?type=sliders_delete&id=" + id;
                xhttp.open("GET", url, true);
                xhttp.send();
            }
        }
    </script>

    <?php include_once('includes/footer.php'); ?>